/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.AudioPanel;
import com.quantumdata.mccs.ChooseFileDialog;
import com.quantumdata.mccs.CommonPanel;
import com.quantumdata.mccs.ConnectDialog;
import com.quantumdata.mccs.Constants;
import com.quantumdata.mccs.DPVLPanel;
import com.quantumdata.mccs.DisplayColorPanel;
import com.quantumdata.mccs.ExtensionFilter;
import com.quantumdata.mccs.GeometryPanel;
import com.quantumdata.mccs.ImagePanel;
import com.quantumdata.mccs.MCCSGUI;
import com.quantumdata.mccs.ManufacturerPanel;
import com.quantumdata.mccs.MiscPanel;
import com.quantumdata.mccs.PresetPanel;
import com.quantumdata.mccs.VCPCodes;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.std.SystemConsole;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MCCSGUIFrame
extends JFrame
implements ActionListener,
DocumentListener {
    private static final String m_version = "1.21";
    private static final long serialVersionUID = 2L;
    private static JToolBar jToolBar;
    private static JButton jConnectButton;
    private static JButton jReCheckDisplayButton;
    private static JButton jRefreshButton;
    private static JButton jCheckCapabilityButton;
    private JSplitPane mainSplitPane;
    private JSplitPane subSplitPane;
    private static JTabbedPane tabPane;
    private static JPanel jMsgLogPanel;
    private static JToolBar jMsgLogToolBar;
    private static JButton jMsgLogEraseButton;
    private static JButton jMsgLogOpenButton;
    private static JButton jMsgLogSaveButton;
    private static JScrollPane jScrollMsgLog;
    private static JTextArea jMessageLog;
    private static JPanel jScriptPanel;
    private static JToolBar jScriptToolBar;
    private static JButton jScriptNewButton;
    private static JButton jScriptOpenButton;
    private static JButton jScriptSaveButton;
    private static JButton jScriptExecButton;
    private static JScrollPane jScrollScriptText;
    private static JTextArea jScriptText;
    private static boolean saveNeeded;
    private static JToolBar jStatusBar;
    private static JTextField jTextConnection;
    private static JTextField jTextDisplayDevice;
    private static JTextField jTextCmdName;
    private static JTextField jTextCmdType;
    private static JTextField jTextCmdFuncType;
    private static int frameW;
    private static int frameH;
    public static RemoteInstrument m_instrument;
    public static boolean connectDisplayDevice;
    private static PresetPanel presetPane;
    private static ImagePanel imagePane;
    private static DisplayColorPanel displayColorPane;
    private static GeometryPanel geometryPane;
    private static MiscPanel miscPane;
    private static AudioPanel audioPane;
    private static DPVLPanel dpvlPane;
    private static ManufacturerPanel manufacturerPane;
    private static int[] readResponse;
    private static int expectedReadRespLength;

    public MCCSGUIFrame() {
        readResponse = new int[32];
    }

    public boolean isSupportedUnit() {
        InstrumentResponse instrumentResponse = m_instrument.sendCmd("*IDN?");
        if (instrumentResponse.isError()) {
            return false;
        }
        String[] stringArray = instrumentResponse.getResponse().split(",");
        if (stringArray.length < 2) {
            return false;
        }
        return stringArray[1].indexOf("881") != 0;
    }

    public void init(boolean bl) {
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        frameW = dimension.width - 60;
        frameH = dimension.height - 60;
        this.setBounds(30, 30, frameW, frameH);
        this.setTitle("Quantum Data MCCS Command Controller 1.21");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        if (m_instrument == null) {
            m_instrument = new RemoteInstrument(new SocketConnection(""), new SystemConsole());
        }
        this.initToolbar();
        this.initMainPane();
        this.initStatusBar();
        MCCSGUIFrame.updateConnectionInformation();
        this.checkDisplayDevice();
        if (bl) {
            this.checkCapability();
            this.initializePanels();
        } else {
            this.supportAllCmds(true);
        }
        this.setVisible(true);
        this.setLocationRelativeTo(null);
    }

    private void initToolbar() {
        jToolBar = new JToolBar();
        jToolBar.addSeparator();
        ImageIcon imageIcon = MCCSGUIFrame.createImageIcon("resources/connect.gif");
        jConnectButton = new JButton("Connect/Disconnect", imageIcon);
        jConnectButton.setFont(Constants.itemFont);
        jConnectButton.setPreferredSize(new Dimension(100, 30));
        jConnectButton.addActionListener(this);
        jToolBar.add(jConnectButton);
        jToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/display.gif");
        jReCheckDisplayButton = new JButton("Re-check Display Status", imageIcon);
        jReCheckDisplayButton.setFont(Constants.itemFont);
        jReCheckDisplayButton.setPreferredSize(new Dimension(100, 30));
        jReCheckDisplayButton.addActionListener(this);
        jToolBar.add(jReCheckDisplayButton);
        jToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/refresh.gif");
        jRefreshButton = new JButton("Refresh Current Panel", imageIcon);
        jRefreshButton.setFont(Constants.itemFont);
        jRefreshButton.setPreferredSize(new Dimension(100, 30));
        jRefreshButton.addActionListener(this);
        jToolBar.add(jRefreshButton);
        jToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/check.gif");
        jCheckCapabilityButton = new JButton("Check Capability", imageIcon);
        jCheckCapabilityButton.setFont(Constants.itemFont);
        jCheckCapabilityButton.setPreferredSize(new Dimension(100, 30));
        jCheckCapabilityButton.addActionListener(this);
        jToolBar.add(jCheckCapabilityButton);
        jToolBar.setFloatable(false);
        this.getContentPane().add((Component)jToolBar, "North");
    }

    private void initMainPane() {
        this.initTabbedPane();
        this.initMsgLogPane();
        this.initScriptPane();
        this.subSplitPane = new JSplitPane(1, jMsgLogPanel, jScriptPanel);
        this.subSplitPane.setOneTouchExpandable(true);
        this.subSplitPane.setDividerLocation((int)((double)frameW * 0.5));
        this.mainSplitPane = new JSplitPane(0, tabPane, this.subSplitPane);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setDividerLocation((int)((double)frameH * 0.6));
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
    }

    private void initTabbedPane() {
        tabPane = new JTabbedPane();
        tabPane.setTabLayoutPolicy(0);
        presetPane = new PresetPanel();
        tabPane.addTab("Preset Command", null, presetPane, "Preset Command Panel");
        imagePane = new ImagePanel();
        tabPane.addTab("Image Adjustments", null, imagePane, "Image Adjustment Command Panel");
        displayColorPane = new DisplayColorPanel();
        tabPane.addTab("Display Control Adjustments", null, displayColorPane, "Control Adjustment Command Panel");
        geometryPane = new GeometryPanel();
        tabPane.addTab("Geometry Adjustments", null, geometryPane, "Geometry Adjustment Command Panel");
        miscPane = new MiscPanel();
        tabPane.addTab("Misc. Adjustments", null, miscPane, "Misc. Adjustment Command Panel");
        audioPane = new AudioPanel();
        tabPane.addTab("Audio Adjustments", null, audioPane, "Audio Adjustment Command Panel");
        dpvlPane = new DPVLPanel();
        tabPane.addTab("DPVL Support", null, dpvlPane, "DPVL Support Command Panel");
        manufacturerPane = new ManufacturerPanel();
        tabPane.addTab("Manufacturer Specified", null, manufacturerPane, "Manufacturer Specified Command Panel");
    }

    private void initMsgLogPane() {
        jMsgLogPanel = new JPanel();
        jMsgLogPanel.setBorder(new TitledBorder("Message Exchange Log"));
        jMsgLogPanel.setLayout(new BorderLayout());
        jMsgLogToolBar = new JToolBar();
        ImageIcon imageIcon = MCCSGUIFrame.createImageIcon("resources/erase.gif");
        jMsgLogEraseButton = new JButton("Erase All", imageIcon);
        jMsgLogEraseButton.setFont(Constants.itemFont);
        jMsgLogEraseButton.addActionListener(this);
        jMsgLogToolBar.add(jMsgLogEraseButton);
        jMsgLogToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/open.gif");
        jMsgLogOpenButton = new JButton("Open", imageIcon);
        jMsgLogOpenButton.setFont(Constants.itemFont);
        jMsgLogOpenButton.addActionListener(this);
        jMsgLogToolBar.add(jMsgLogOpenButton);
        jMsgLogToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/save.gif");
        jMsgLogSaveButton = new JButton("Save", imageIcon);
        jMsgLogSaveButton.setFont(Constants.itemFont);
        jMsgLogSaveButton.addActionListener(this);
        jMsgLogToolBar.add(jMsgLogSaveButton);
        jMsgLogToolBar.addSeparator();
        jMsgLogToolBar.setFloatable(false);
        jMsgLogPanel.add((Component)jMsgLogToolBar, "North");
        jScrollMsgLog = new JScrollPane();
        jMessageLog = new JTextArea();
        jMessageLog.setEditable(false);
        jMessageLog.setFont(new Font("Monospaced", 0, 12));
        jMessageLog.setLineWrap(true);
        jMessageLog.setWrapStyleWord(true);
        jScrollMsgLog.setViewportView(jMessageLog);
        jMsgLogPanel.add((Component)jScrollMsgLog, "Center");
    }

    private void initScriptPane() {
        jScriptPanel = new JPanel();
        jScriptPanel.setBorder(new TitledBorder("Script"));
        jScriptPanel.setLayout(new BorderLayout());
        jScriptToolBar = new JToolBar();
        ImageIcon imageIcon = MCCSGUIFrame.createImageIcon("resources/new.gif");
        jScriptNewButton = new JButton("New", imageIcon);
        jScriptNewButton.setFont(Constants.itemFont);
        jScriptNewButton.addActionListener(this);
        jScriptToolBar.add(jScriptNewButton);
        jScriptToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/open.gif");
        jScriptOpenButton = new JButton("Open", imageIcon);
        jScriptOpenButton.setFont(Constants.itemFont);
        jScriptOpenButton.addActionListener(this);
        jScriptToolBar.add(jScriptOpenButton);
        jScriptToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/save.gif");
        jScriptSaveButton = new JButton("Save", imageIcon);
        jScriptSaveButton.setFont(Constants.itemFont);
        jScriptSaveButton.addActionListener(this);
        jScriptToolBar.add(jScriptSaveButton);
        jScriptToolBar.addSeparator();
        imageIcon = MCCSGUIFrame.createImageIcon("resources/play.gif");
        jScriptExecButton = new JButton("Exec", imageIcon);
        jScriptExecButton.setFont(Constants.itemFont);
        jScriptExecButton.addActionListener(this);
        jScriptToolBar.add(jScriptExecButton);
        jScriptToolBar.setFloatable(false);
        jScriptPanel.add((Component)jScriptToolBar, "North");
        jScrollScriptText = new JScrollPane();
        jScriptText = new JTextArea();
        jScriptText.setEditable(true);
        jScriptText.setFont(new Font("Monospaced", 0, 12));
        jScriptText.setLineWrap(true);
        jScriptText.setWrapStyleWord(true);
        jScrollScriptText.setViewportView(jScriptText);
        jScriptPanel.add((Component)jScrollScriptText, "Center");
    }

    private void initStatusBar() {
        jStatusBar = new JToolBar();
        jStatusBar.setFloatable(false);
        jTextConnection = new JTextField();
        jTextConnection.setEditable(false);
        jTextConnection.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        jTextConnection.setFocusable(false);
        jTextConnection.setFont(Constants.itemFont);
        jStatusBar.add(jTextConnection);
        jTextDisplayDevice = new JTextField();
        jTextDisplayDevice.setEditable(false);
        jTextDisplayDevice.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        jTextDisplayDevice.setFocusable(false);
        jTextDisplayDevice.setFont(Constants.itemFont);
        jStatusBar.add(jTextDisplayDevice);
        jTextCmdName = new JTextField();
        jTextCmdName.setEditable(false);
        jTextCmdName.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        jTextCmdName.setFocusable(false);
        jTextCmdName.setFont(Constants.itemFont);
        jStatusBar.add(jTextCmdName);
        jTextCmdType = new JTextField();
        jTextCmdType.setEditable(false);
        jTextCmdType.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        jTextCmdType.setFocusable(false);
        jTextCmdType.setFont(Constants.itemFont);
        jStatusBar.add(jTextCmdType);
        jTextCmdFuncType = new JTextField();
        jTextCmdFuncType.setEditable(false);
        jTextCmdFuncType.setHorizontalAlignment(4);
        jTextCmdFuncType.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        jTextCmdFuncType.setFocusable(false);
        jTextCmdFuncType.setFont(Constants.itemFont);
        jStatusBar.add(jTextCmdFuncType);
        this.getContentPane().add((Component)jStatusBar, "South");
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        m_instrument = remoteInstrument;
    }

    public void disconnect() {
        if (m_instrument != null) {
            m_instrument.disconnect();
        }
    }

    private static boolean isConnected() {
        return m_instrument != null && m_instrument.isConnected();
    }

    public static void updateConnectionInformation() {
        if (MCCSGUIFrame.isConnected()) {
            jTextConnection.setText("Connected to " + m_instrument.getConnection().getName() + ".");
        } else {
            jTextConnection.setText("Not Connected");
        }
    }

    private void checkDisplayDevice() {
        if (MCCSGUIFrame.isConnected()) {
            String string = "EDID?";
            InstrumentResponse instrumentResponse = m_instrument.sendCmd(string);
            if (!instrumentResponse.isError()) {
                jTextDisplayDevice.setText("Display device connected");
                connectDisplayDevice = true;
            } else {
                JOptionPane.showMessageDialog(null, "No display device connected!", "No display device connection", 0);
                jTextDisplayDevice.setText("No display device connected");
            }
        } else {
            jTextDisplayDevice.setText("Connected display device: N/A");
        }
    }

    private void checkCapability() {
        String string = MCCSGUIFrame.sendCmdGetResp("dptx:mcap?");
        if (string == null) {
            this.supportAllCmds(true);
        } else {
            this.supportAllCmds(false);
            this.printCapability(string);
        }
        this.refreshPanelContents();
    }

    private void supportAllCmds(boolean bl) {
        for (int i = 0; i < tabPane.getComponentCount(); ++i) {
            ((CommonPanel)tabPane.getComponentAt(i)).supportAllCmds(bl);
        }
    }

    private void printCapability(String string) {
        int n;
        int n2;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < string.length() - 2; n2 += 2) {
            n = Integer.parseInt(string.substring(n2, n2 + 2), 16);
            string2 = string2 + (char)n;
            if (n2 <= 1 || bl) continue;
            if (string2.contains("vcp(")) {
                string3 = string3 + (char)n;
                if (n == 40) {
                    ++n3;
                }
                if (n == 41) {
                    ++n4;
                }
            }
            if (n3 == 0 || n3 != n4) continue;
            bl = true;
        }
        jMessageLog.append(string2 + "\n\n");
        String string4 = "";
        n3 = 0;
        n4 = 0;
        for (n2 = 1; n2 < string3.length(); ++n2) {
            n = string3.charAt(n2);
            if (n == 32 && n3 == n4) {
                jMessageLog.append(this.getVcpDetails(string4) + "\n");
                string4 = "";
                continue;
            }
            if (n == 40) {
                ++n3;
            } else if (n == 41) {
                ++n4;
            }
            string4 = string4 + (char)n;
        }
        if (!string4.equalsIgnoreCase("")) {
            jMessageLog.append(this.getVcpDetails(string4) + "\n");
        }
        jMessageLog.append("\n");
    }

    private String getVcpDetails(String string) {
        String string2 = "";
        for (int i = 0; i < tabPane.getComponentCount(); ++i) {
            string2 = ((CommonPanel)tabPane.getComponentAt(i)).getVcpDetails(string);
            if (string2.equals("")) continue;
            return string2;
        }
        return string2;
    }

    private void refreshPanelContents() {
        for (int i = 0; i < tabPane.getComponentCount(); ++i) {
            ((CommonPanel)tabPane.getComponentAt(i)).refreshPanelContents();
        }
    }

    private void initializePanels() {
        imagePane.getAllValues(false, true);
        displayColorPane.getAllValues(false, true);
        geometryPane.getAllValues(false, true);
        miscPane.getAllValues(false, true);
        audioPane.getAllValues(false, true);
        dpvlPane.getAllValues(false, true);
        manufacturerPane.getAllValues(false, true);
        jTextCmdName.setText("");
        jTextCmdType.setText("");
        jTextCmdFuncType.setText("");
    }

    public static boolean isDisplayDeviceConnected() {
        return connectDisplayDevice;
    }

    private static int getByteLength(String string) {
        return MCCSGUIFrame.getHalf(string.length());
    }

    private static int getHalf(int n) {
        if (n % 2 == 0) {
            return n / 2;
        }
        return n / 2 + 1;
    }

    public static boolean allConnected(boolean bl) {
        if (!MCCSGUIFrame.isConnected()) {
            if (bl) {
                JOptionPane.showMessageDialog(null, "Must connect to a generator first!", "No generator connection", 0);
            }
            return false;
        }
        if (!MCCSGUIFrame.isDisplayDeviceConnected()) {
            if (bl) {
                JOptionPane.showMessageDialog(null, "No display device connected!", "No display device connection", 0);
            }
            return false;
        }
        return true;
    }

    public static int readFromDisplay(VCPCodes vCPCodes, String string, int n, boolean bl) {
        return MCCSGUIFrame.readFromDisplay(vCPCodes, string, MCCSGUIFrame.getByteLength(string), n, true, bl);
    }

    public static int readFromDisplay(VCPCodes vCPCodes, int n, boolean bl) {
        return MCCSGUIFrame.readFromDisplay(vCPCodes, null, 0, n, false, bl);
    }

    public static int readFromDisplay(VCPCodes vCPCodes, boolean bl) {
        return MCCSGUIFrame.readFromDisplay(vCPCodes, null, 0, 4, false, bl);
    }

    private static int readFromDisplay(VCPCodes vCPCodes, String string, int n, int n2, boolean bl, boolean bl2) {
        if (!vCPCodes.isSupported()) {
            return 0;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        expectedReadRespLength = n2;
        MCCSGUIFrame.fillStatusBar(vCPCodes);
        String string2 = "dptx:mccs";
        string2 = bl ? string2 + "? " + vCPCodes.getVcpCode() + " " + string : string2 + "? " + vCPCodes.getVcpCode();
        String string3 = MCCSGUIFrame.sendCmdGetResp(string2, bl2);
        if (string3 == null) {
            return 0;
        }
        int n3 = string3.length() / 2;
        if (string3.length() % 2 == 1 || n3 != n2) {
            MCCSGUIFrame.showInvalidRespLength();
            return 0;
        }
        for (int i = 0; i < n3; ++i) {
            MCCSGUIFrame.readResponse[i] = string3.substring(i * 2, i * 2 + 1).equals(" ") ? Integer.parseInt(string3.substring(i * 2 + 1, i * 2 + 2), 16) : Integer.parseInt(string3.substring(i * 2, i * 2 + 2), 16);
        }
        return n3;
    }

    public static int getReadRespByte(int n) {
        return readResponse[n];
    }

    public static String getReadRespString(int n) {
        return Integer.toHexString(readResponse[n]);
    }

    public static String getReadRespCurrentValueString() {
        String string = "";
        for (int i = expectedReadRespLength / 2; i < expectedReadRespLength; ++i) {
            string = string + MCCSGUIFrame.getReadRespString(i);
        }
        return string;
    }

    public static int getReadRespMH() {
        return readResponse[expectedReadRespLength - 4];
    }

    public static int getReadRespML() {
        return readResponse[expectedReadRespLength - 3];
    }

    public static int getReadRespSH() {
        return readResponse[expectedReadRespLength - 2];
    }

    public static int getReadRespSL() {
        return readResponse[expectedReadRespLength - 1];
    }

    public static int getReadRespSupportValue() {
        int n = 0;
        for (int i = 0; i < expectedReadRespLength / 2; ++i) {
            n |= readResponse[i] << 8 * (expectedReadRespLength / 2 - 1 - i);
        }
        return n;
    }

    public static int getReadRespCurrentValue() {
        int n = 0;
        for (int i = expectedReadRespLength / 2; i < expectedReadRespLength; ++i) {
            n |= readResponse[i] << 8 * (expectedReadRespLength - 1 - i);
        }
        return n;
    }

    public static String getTableReadResp() {
        String string = "";
        for (int i = 0; i < expectedReadRespLength; ++i) {
            string = string + MCCSGUIFrame.getReadRespString(i);
        }
        return string;
    }

    public static void showInvalidRespLength() {
        jMessageLog.append("Response length is invalid!!!");
    }

    public static String convertTextToParameter(String string, int n) {
        int n2 = string.length();
        String string2 = "";
        if (n2 > n * 2) {
            for (int i = 0; i < n - 1; ++i) {
                string2 = string2 + string.substring(n2 - (n - i) * 2, n2 - (n - i) * 2 + 1);
                string2 = string2 + " ";
            }
            string2 = string2 + string.substring(n2 - 2, n2 - 1);
        } else {
            int n3;
            for (n3 = 0; n3 < n - MCCSGUIFrame.getHalf(n2); ++n3) {
                string2 = string2 + "0 ";
            }
            if (n2 % 2 == 0) {
                for (n3 = 0; n3 < n2; n3 += 2) {
                    string2 = string2 + string.substring(n3, n3 + 2) + " ";
                }
            } else {
                string2 = string2 + string.substring(0, 1);
                for (n3 = 1; n3 < n2; n3 += 2) {
                    string2 = string2 + " " + string.substring(n3, n3 + 2);
                }
            }
        }
        return string2;
    }

    public static void writeToDisplay(String string, VCPCodes vCPCodes) {
        if (string == "Reserved") {
            MCCSGUIFrame.writeToDisplay(vCPCodes, vCPCodes.getValueForReserved());
        } else {
            MCCSGUIFrame.writeToDisplay(vCPCodes, string.substring(0, 2));
        }
    }

    public static void writeStringToDisplay(VCPCodes vCPCodes, String string, int n) {
        MCCSGUIFrame.fillStatusBar(vCPCodes);
        String string2 = "dptx:mccs " + vCPCodes.getVcpCode() + " " + Integer.toHexString(n) + " " + string;
        MCCSGUIFrame.sendCmdGetResp(string2);
    }

    public static void writeToDisplay(VCPCodes vCPCodes, int n) {
        MCCSGUIFrame.writeToDisplay(vCPCodes, Integer.toHexString(n), 2);
    }

    public static void writeToDisplay(VCPCodes vCPCodes, int n, int n2) {
        MCCSGUIFrame.writeToDisplay(vCPCodes, Integer.toHexString(n), n2);
    }

    public static void writeToDisplay(VCPCodes vCPCodes, String string) {
        MCCSGUIFrame.writeToDisplay(vCPCodes, string, 2);
    }

    public static void writeToDisplay(VCPCodes vCPCodes, String string, int n) {
        MCCSGUIFrame.fillStatusBar(vCPCodes);
        String string2 = "dptx:mccs " + vCPCodes.getVcpCode() + " " + n + " " + MCCSGUIFrame.convertTextToParameter(string, n);
        MCCSGUIFrame.sendCmdGetResp(string2);
    }

    public static void setBacklightControl() {
        imagePane.setBacklightControl();
    }

    private static void fillStatusBar(VCPCodes vCPCodes) {
        jTextCmdName.setText(vCPCodes.getCmdName());
        jTextCmdType.setText(vCPCodes.getType());
        jTextCmdFuncType.setText(vCPCodes.getFuncType());
    }

    private static String sendCmdGetResp(String string) {
        return MCCSGUIFrame.sendCmdGetResp(string, true);
    }

    private static String sendCmdGetResp(String string, boolean bl) {
        if (MCCSGUIFrame.isConnected()) {
            InstrumentResponse instrumentResponse = m_instrument.sendCmd(string);
            if (bl) {
                jMessageLog.append(string);
                if (instrumentResponse.isError()) {
                    jMessageLog.setForeground(Color.RED);
                    jMessageLog.append("  - FAILED\n");
                } else {
                    jMessageLog.setForeground(Color.GREEN);
                    jMessageLog.append("  - SUCCESS\n");
                }
                jMessageLog.setForeground(Color.BLACK);
            }
            if (!string.equalsIgnoreCase("dptx:mcap?")) {
                if (instrumentResponse.getResponse().contains("9463")) {
                    jMessageLog.append("Command is NOT supported by the Display Device!\n");
                } else {
                    jMessageLog.append(instrumentResponse.getResponse() + "\n");
                }
            }
            if (instrumentResponse.isError()) {
                return null;
            }
            return instrumentResponse.getResponse();
        }
        JOptionPane.showMessageDialog(null, "Must connect to a generator first!", "No generator connection", 0);
        return null;
    }

    private boolean checkForMsgLogSave(boolean bl) {
        boolean bl2 = true;
        if (!jMessageLog.getText().equals("")) {
            int n;
            if (bl) {
                Object[] objectArray = new Object[]{"Save current log first", "Open another log without Save", "Do Nothing"};
                n = JOptionPane.showOptionDialog(this, "Message Log is NOT empty!  Do you want to:", "Confirm Open", 1, 3, null, objectArray, objectArray[1]);
            } else {
                Object[] objectArray = new Object[]{"Save current log first", "Erase log without Save", "Do Nothing"};
                n = JOptionPane.showOptionDialog(this, "Message Log is NOT empty!  Do you want to:", "Confirm Erase", 1, 3, null, objectArray, objectArray[1]);
            }
            if (n == 0) {
                if (!this.saveToFile(false)) {
                    bl2 = false;
                }
            } else if (n == 2) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private void eraseMsgLog() {
        if (!this.checkForMsgLogSave(false)) {
            return;
        }
        jMessageLog.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMsgLogFile() {
        if (!this.checkForMsgLogSave(true)) {
            return;
        }
        ChooseFileDialog chooseFileDialog = new ChooseFileDialog("Open Message Log", "Open", "Open messaage log file", 0, new ExtensionFilter(".txt", "MCCS message log files (*.txt)"), this, new File("*", ""));
        File file = chooseFileDialog.getFile();
        if (file != null) {
            BufferedReader bufferedReader = null;
            try {
                jMessageLog.setText("");
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    jMessageLog.append(string + "\n");
                }
            }
            catch (Exception exception) {
                jMessageLog.append("\n" + exception.getClass().getName() + " Error: " + exception.getMessage() + "\n");
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        } else if (chooseFileDialog.userClickedButton == 0) {
            JOptionPane.showMessageDialog(null, "You must choose a valid message log file!", "No Message Log File Specified", 0);
        }
    }

    private boolean saveToFile(boolean bl) {
        Object object;
        ChooseFileDialog chooseFileDialog = bl ? new ChooseFileDialog("Save Script", "Save", "Save the script file", 0, new ExtensionFilter(".txt", "MCCS Script files (*.txt)"), this, new File("*", "")) : new ChooseFileDialog("Save Message Log", "Save", "Save message log file", 0, new ExtensionFilter(".txt", "MCCS message log files (*.txt)"), this, new File("*", ""));
        File file = null;
        File file2 = chooseFileDialog.getFile();
        if (file2 == null) {
            return false;
        }
        if (!file2.getName().endsWith(".txt")) {
            object = new File(file2.getAbsolutePath().concat(".txt"));
            file = object;
        } else {
            file = file2;
        }
        if (file.exists() && 1 == JOptionPane.showConfirmDialog(this, "The specified file already exists!\n Do you want to overwrite it?", "Overwrite", 0)) {
            return false;
        }
        try {
            object = new PrintWriter((Writer)new FileWriter(file), true);
            if (bl) {
                ((PrintWriter)object).print(jScriptText.getTabSize());
            } else {
                ((PrintWriter)object).print(jMessageLog.getText());
            }
            ((PrintWriter)object).close();
            saveNeeded = false;
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "There was an I/O error while attempting to save the trace: " + iOException.getMessage());
            return false;
        }
    }

    private boolean checkForScriptSave(boolean bl) {
        boolean bl2 = true;
        if (saveNeeded) {
            int n = JOptionPane.showConfirmDialog(this, "Current script has been changed.\nDo you want to save it first?", "Confirm new", 1);
            if (n == 0) {
                if (!this.saveToFile(true)) {
                    bl2 = false;
                }
            } else if (n == 2) {
                bl2 = false;
            } else {
                saveNeeded = false;
            }
        } else {
            String string = bl ? "open another" : "start a new";
            int n = JOptionPane.showConfirmDialog(this, "Do you want to " + string + " MCCS Script file? \n Current contents will be overwritten.", "Confirm open", 0);
            if (n == 1) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private void newScriptFile() {
        if (!this.checkForScriptSave(false)) {
            return;
        }
        jScriptText.getDocument().removeDocumentListener(this);
        jScriptText.setText("");
        jScriptText.getDocument().addDocumentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openScriptFile() {
        if (!this.checkForScriptSave(true)) {
            return;
        }
        ChooseFileDialog chooseFileDialog = new ChooseFileDialog("Open Script", "Open", "Open the script file", 0, new ExtensionFilter(".txt", "MCCS Script files (*.txt)"), this, new File("*", ""));
        File file = chooseFileDialog.getFile();
        if (file != null) {
            BufferedReader bufferedReader = null;
            try {
                jScriptText.getDocument().removeDocumentListener(this);
                jScriptText.setText("");
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    jScriptText.append(string + "\n");
                }
                jScriptText.getDocument().addDocumentListener(this);
            }
            catch (Exception exception) {
                jScriptText.append("\n" + exception.getClass().getName() + " Error: " + exception.getMessage() + "\n");
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        } else if (chooseFileDialog.userClickedButton == 0) {
            JOptionPane.showMessageDialog(null, "You must choose a valid script file!", "No Script File Specified", 0);
        }
    }

    private void execScriptFile() {
        String string = jScriptText.getText();
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        if (string.length() == 0) {
            return;
        }
        while (n2 < string.length() && bl) {
            String string2;
            n2 = string.indexOf("\n", n);
            if (n2 == -1) {
                string2 = string.substring(n);
                bl = false;
            } else {
                string2 = string.substring(n, n2);
                n = n2 + 1;
            }
            if (!string2.startsWith("dptx:mccs")) continue;
            MCCSGUIFrame.sendCmdGetResp(string2);
        }
        ((CommonPanel)tabPane.getSelectedComponent()).getAllValues(true, false);
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = MCCSGUIFrame.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == jConnectButton) {
            new ConnectDialog((Frame)MCCSGUI.theApp, true).setVisible(true);
        }
        if (jButton == jReCheckDisplayButton) {
            this.checkDisplayDevice();
        } else if (jButton == jRefreshButton) {
            ((CommonPanel)tabPane.getSelectedComponent()).getAllValues(true, true);
        } else if (jButton == jCheckCapabilityButton) {
            this.checkCapability();
        } else if (jButton == jMsgLogEraseButton) {
            this.eraseMsgLog();
        } else if (jButton == jMsgLogOpenButton) {
            this.openMsgLogFile();
        } else if (jButton == jMsgLogSaveButton) {
            this.saveToFile(false);
        } else if (jButton == jScriptNewButton) {
            this.newScriptFile();
        } else if (jButton == jScriptOpenButton) {
            this.openScriptFile();
        } else if (jButton == jScriptSaveButton) {
            this.saveToFile(true);
        } else if (jButton == jScriptExecButton) {
            this.execScriptFile();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new UpdateEditorTabTitle());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new UpdateEditorTabTitle());
    }

    static {
        saveNeeded = false;
        m_instrument = null;
        connectDisplayDevice = false;
        expectedReadRespLength = 4;
    }

    private class UpdateEditorTabTitle
    implements Runnable {
        private UpdateEditorTabTitle() {
        }

        public void run() {
            saveNeeded = true;
        }
    }
}

